proc tabulate data = ghpb18;
where filingsize in ('1','3');
class ent3 INS3 filingsize / PRELOADFMT;
TITLE 'Table A5. Selected Expenses of Group Health Plans';
title2 'by type of insurance and type of plan, 2018';
title3 '(millions)';
title4 'All Plans with Trusts';
var tot_contrib_AME emplr_contrib_income_AME participant_contrib_AME oth_contrib_rcvd_AME
tot_distrib_bnft_AME distrib_drt_partcp_AME ins_carrier_bnfts_AME ioh_ben
tot_admin_expenses_AME professional_fees_AME contract_admin_fees_AME invst_mgmt_fees_AME IOH_AEXP;
table (tot_distrib_bnft_AME='BENEFIT PAYMENTS'
distrib_drt_partcp_AME='Directly to Participants or Beneficiaries (Including Rollovers)'
ins_carrier_bnfts_AME='To Insurance Carriers for the Provision of Benefits'
ioh_ben='Other'
tot_admin_expenses_AME='ADMINISTRATIVE EXPENSES'
professional_fees_AME='Professional Fees'
contract_admin_fees_AME='Contract Administrator Fees'
invst_mgmt_fees_AME='Investment Advisory and Management Fees'
IOH_AEXP='Other')*sum=' '*f=m12f_2stars., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/ Box='Selected Expenses' MISSTEXT='-';
run;

proc tabulate data = ghpb18;
WHERE FILINGSIZE='1';
class ent3 INS3 filingsize / PRELOADFMT;
TITLE 'Table A5. Selected Expenses of Group Health Plans';
title2 'by type of insurance and type of plan, 2018';
title3 '(millions)';
title4 'Plans with 100 or More Participants and Trusts';
var tot_contrib_AME emplr_contrib_income_AME participant_contrib_AME oth_contrib_rcvd_AME
tot_distrib_bnft_AME distrib_drt_partcp_AME ins_carrier_bnfts_AME ioh_ben
tot_admin_expenses_AME professional_fees_AME contract_admin_fees_AME invst_mgmt_fees_AME IOH_AEXP;
table (tot_distrib_bnft_AME='BENEFIT PAYMENTS'
distrib_drt_partcp_AME='Directly to Participants or Beneficiaries (Including Rollovers)'
ins_carrier_bnfts_AME='To Insurance Carriers for the Provision of Benefits'
ioh_ben='Other'
tot_admin_expenses_AME='ADMINISTRATIVE EXPENSES'
professional_fees_AME='Professional Fees'
contract_admin_fees_AME='Contract Administrator Fees'
invst_mgmt_fees_AME='Investment Advisory and Management Fees'
IOH_AEXP='Other')*sum=' '*f=m12f_2stars., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/ Box='Selected Expenses' MISSTEXT='-';
run;

proc tabulate data = ghpb18;
WHERE FILINGSIZE='3';
class ent3 INS3 filingsize / PRELOADFMT;
TITLE 'Table A5. Selected Expenses of Group Health Plans';
title2 'by type of insurance and type of plan, 2018';
title3 '(millions)';
title4 'Plans with Fewer Than 100 Participants and Trusts';
var tot_contrib_AME emplr_contrib_income_AME participant_contrib_AME oth_contrib_rcvd_AME
tot_distrib_bnft_AME distrib_drt_partcp_AME ins_carrier_bnfts_AME ioh_ben
tot_admin_expenses_AME professional_fees_AME contract_admin_fees_AME invst_mgmt_fees_AME IOH_AEXP;
table (tot_distrib_bnft_AME='BENEFIT PAYMENTS'
distrib_drt_partcp_AME='Directly to Participants or Beneficiaries (Including Rollovers)'
ins_carrier_bnfts_AME='To Insurance Carriers for the Provision of Benefits'
ioh_ben='Other'
tot_admin_expenses_AME='ADMINISTRATIVE EXPENSES'
professional_fees_AME='Professional Fees'
contract_admin_fees_AME='Contract Administrator Fees'
invst_mgmt_fees_AME='Investment Advisory and Management Fees'
IOH_AEXP='Other')*sum=' '*f=m12f_2stars., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/ Box='Selected Expenses' MISSTEXT='-';
run;
